/*
 * Decompiled with CFR 0.152.
 */
package org.spoorn.climbladdersfast.mixin;

import net.minecraft.core.Registry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spoorn.climbladdersfast.config.ModConfig;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    private LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"applyClimbingSpeed"}, at={@At(value="TAIL")}, cancellable=true)
    public void adjustClimbingSpeed(Vec3 motion, CallbackInfoReturnable<Vec3> cir) {
        BlockState climbingBlockState;
        LivingEntity livingEntity = (LivingEntity)this;
        if (!livingEntity.m_6147_() || livingEntity.m_6144_() || !(livingEntity instanceof Player)) {
            return;
        }
        boolean disableScaffolding = ModConfig.get().disableScaffoldingFastClimbing;
        boolean disableVines = ModConfig.get().disableVinesFastClimbing;
        if ((disableScaffolding || disableVines) && (climbingBlockState = super.m_146900_()) != null) {
            String id = Registry.f_122824_.m_7981_((Object)climbingBlockState.m_60734_()).toString();
            if (disableScaffolding && id.equals(Registry.f_122824_.m_7981_((Object)Blocks.f_50616_).toString()) || disableVines && id.contains("vine")) {
                return;
            }
        }
        if (this.isEntityLookingUpOrDown(livingEntity) && this.isEntityStill(livingEntity)) {
            Vec3 vec3d = (Vec3)cir.getReturnValue();
            double y = vec3d.m_7098_();
            if (this.isEntityLookingUp(livingEntity)) {
                y = this.getNormalizedPitch(livingEntity.m_146909_()) * ModConfig.get().climbUpSpeed;
            } else if (this.isEntityLookingDown(livingEntity)) {
                y = this.getNormalizedPitch(livingEntity.m_146909_()) * ModConfig.get().climbDownSpeed * -1.0;
            }
            cir.setReturnValue((Object)new Vec3(vec3d.m_7096_(), y, vec3d.m_7094_()));
        }
    }

    private boolean isEntityLookingUp(LivingEntity livingEntity) {
        return livingEntity.m_146909_() < 0.0f;
    }

    private boolean isEntityLookingDown(LivingEntity livingEntity) {
        return livingEntity.m_146909_() > 0.0f;
    }

    private boolean isEntityLookingUpOrDown(LivingEntity livingEntity) {
        return livingEntity.m_146909_() != 0.0f;
    }

    private boolean isEntityStill(LivingEntity livingEntity) {
        return livingEntity.f_20902_ == 0.0f;
    }

    private double getNormalizedPitch(float pitch) {
        return Math.abs((double)pitch / 90.0);
    }
}

